from visual import *

class Spin:   
    def __init__(self):
        self.vector = arrow(visible=0)
        self.torqueVector = arrow(visible=0)
        self.fieldVector = arrow(visible=0)
        self.point = sphere(visible=0)
        self.position = vector()
        self.torqueScale = 5.0

        self.tvVectors = 0
        self.tvTorqueVectors = 0
        self.tvPoints = 0
        self.tvFieldVectors = 0

    def setArrow(self, arrowPos, color, width):
        self.vector.pos = arrowPos
        self.vector.color = color
        self.vector.shaftWidth = width

    def setPoint(self, color, radius):
        self.point.color = color
        self.point.radius = radius

    def setTorqueArrow(self, arrowPos, color, width):
        self.torqueVector.pos = arrowPos
        self.torqueVector.color = color
        self.torqueVector.shaftWidth = width

    def setFieldArrow(self, arrowPos, color, width):
        self.fieldVector.pos = arrowPos
        self.fieldVector.color = color
        self.fieldVector.shaftWidth = width

    def updateVectorPos(self, pos):
        self.vector.pos = pos

    def updateVectorAxis(self, axis):
        self.vector.axis = axis

    def updateTorqueVectorPos(self, pos):
        self.torqueVector.pos = pos

    def updateTorqueVectorAxis(self, axis):
        self.torqueVector.axis = axis/self.torqueScale

    def updateFieldVectorPos(self, pos):
        self.fieldVector.pos = pos

    def updateFieldVectorAxis(self, axis):
        self.fieldVector.axis = axis

    def updatePointPos(self, pos):
        self.point.pos = pos
        
    def updatePointColor(self, color):
        self.point.color = color

    def getVectorPos(self):
        return self.vector.pos
    
    def getVectorAxis(self):
        return self.vector.axis
        
    def toggleVectorVisibility(self):
        self.tvVectors = (self.tvVectors+1)%2
        self.vector.visible = self.tvVectors

    def toggleTorqueVectorVisibility(self):
        self.tvTorqueVectors = (self.tvTorqueVectors+1)%2
        self.torqueVector.visible = self.tvTorqueVectors

    def togglePointVisibility(self):
        self.tvPoints = (self.tvPoints+1)%2
        self.point.visible = self.tvPoints

    def toggleFieldVectorVisibility(self):
        self.tvFieldVectors = (self.tvFieldVectors+1)%2
        self.fieldVector.visible = self.tvFieldVectors
        
